define([
    'backbone',
    'models/singleton-collection',
], function(Backbone, Collection) {
    'use strict';

    var CCTypeOfCare = Backbone.Model.extend({
        idAttribute: 'typeOfCare',
        defaults: {
            'typeOfCare': '',
            'displayName': '',
            'name': '',
            'details': '',
        },
    });

    return Collection.extend({
        resourceName: 'community-care-typeOfCares',
        defaultsFetchOptions: {
            cache: false,
        },
        model: CCTypeOfCare,
        comparator: 'typeOfCare',
    });
});
